#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <pthread.h>
#include <unistd.h>

#define N 10
#define NEMA -1
#define CAR 0
#define BUS 1
#define KAMION 2

pthread_mutex_t mutex;
pthread_cond_t cv;

int car = 0;
int bus = 0;
int kamion = 0;
int broj_vozila = 0;
int smer_puta = NEMA;
const char* tipovi[] = {"AUTO", "BUS", "KAMION"};

void udji(int id, int tip, int smer) {
    
    pthread_mutex_lock(&mutex);

    if(tip == CAR) {
        while(kamion > 0 || 
            (broj_vozila > 0 && smer != smer_puta && smer_puta != NEMA))
            pthread_cond_wait(&cv, &mutex);
        
        car++;
    } else if (tip == BUS) {
        while(bus > 0 || kamion > 0
            || (broj_vozila > 0 && smer != smer_puta && smer_puta != NEMA))
            pthread_cond_wait(&cv, &mutex);

        bus++;
    } else {
        while(kamion > 0 || bus > 0 || car > 0 
                || (broj_vozila > 0 && smer != smer_puta && smer_puta != NEMA))
            pthread_cond_wait(&cv, &mutex);

        kamion++;
    }

    if(smer_puta != smer) {
        smer_puta = smer;
        broj_vozila = 0;
    }

    broj_vozila++;

    printf("Nit %d | Tip: %s | Smer: %d | Usao sam! <--> AUTO %d BUS %d KAM %d BR_VOZ %d SMER %d\n", 
        id, tipovi[tip], smer, car, bus, kamion, broj_vozila, smer_puta);
    
    pthread_mutex_unlock(&mutex);
}

void izadji(int id, int tip, int smer) {
    pthread_mutex_lock(&mutex);

    if(tip == CAR) {

        car--;

    } else if (tip == BUS) {

        bus--;

    } else {

        kamion--;
    
    }

    broj_vozila--;

    printf("Nit %d | Tip: %s | Smer: %d | Izasao sam! <--> AUTO %d BUS %d KAM %d BR_VOZ %d SMER %d\n", 
        id, tipovi[tip], smer, car, bus, kamion, broj_vozila, smer_puta);

    pthread_cond_broadcast(&cv);

    pthread_mutex_unlock(&mutex);
}

void* voznja(void* arg) {
    int id = *(int*)arg;
    int tip = rand() % 3;
    int smer = rand() % 2;

    printf("Nit %d | Tip: %s | Smer: %d ...\n", 
    id, tipovi[tip], smer);

    udji(id, tip, smer);

    sleep(rand() % 3);

    izadji(id, tip, smer);
}

int main() {
    srand(time(NULL));
    pthread_mutex_init(&mutex, NULL);
    pthread_cond_init(&cv, NULL);

    pthread_t niti[N];
    int ids[N];

    int i;
    for(i = 0; i < N; i++) {
        ids[i] = i;
        pthread_create(&niti[i], NULL, voznja, &ids[i]);
    }

    for(i = 0; i < N; i++) {
        pthread_join(niti[i], NULL);
    }

    return 0;
}